// Copyright (c) Caliper Corporation 2003.  All Rights Reserved
// Written by Phil Villars - Caliper Corporation - 2003

    // This macro demonstrates the use of the AddAnnotation() function

    // The macro illustrates how to:
    // 1. Add different annotation types
    // 2. Use different styles for the different annotation types

    // You can modify the macro to add different annotation types
    // and to add annotations to layouts or a different map.

    // To run this macro using the GISDK toolbox:
    // 1. Open or make current the Maptitude\Tutorial\STATES.MAP.
    // 2. Choose Tools-Add-Ins and open the GIS Developer's Kit toolbox.
    // 3. Compile this macro in test mode using the first button (Compile).
    // 4. Run this macro by clicking the second button (Test), typing the macro 
    //    name "Annotations", clicking the Macro radio button, and clicking OK.

Macro "Annotations"

    // Add a font character annotation to the specified map at the specified location
    // using the specified styles
    id1 = AddAnnotation("Map|States of the United States",
           "Font Character",
           {{"Location", coord(-100000000, 45000000)},
	        {"Font", "Arial|Bold|24"},
		    {"Index", 63},
		    {"Color", ColorRGB(5000,1000,50000)}}
	       )
    
    // Add a bitmap annotation to the specified map at the specified location
    id2 = AddAnnotation("Map|States of the United States",
           "Bitmap",
           {{"Location", {coord(-110000000, 45000000),
                          coord(-105000000, 42000000)}},
	        {"File", "bmp\\geo.bmp"}}
	       )
    
    // Add a text annotation to the specified map at the specified location
    // using the specified styles
    id3 = AddAnnotation("Map|States of the United States",
           "Text",
           {{"Location", {coord(-85000000, 41000000),
                          coord(-84000000, 40000000)}},
            {"Font", "Times New Roman|14"},
            {"Color", ColorRGB(38000, 22000, 20000)},
		    {"Text", "Text Annotation"}}
	       )
    
    // Add a text annotation with a frame to the specified map at the specified location
    // using the specified styles
    id4 = AddAnnotation("Map|States of the United States",
           "Text",
	       {{"Location", {coord(-85000000, 39000000),
	                      coord(-84000000, 38000000)}},
		    {"Font", "Times New Roman|Bold|12"},
		    {"Color", ColorRGB(65535, 65535, 65535)},
		    {"Framed", "True"},
		    {"Frame Fill Color", ColorRGB(0, 0, 0)},
		    {"Frame Fill Style", FillStyle({"XXXXXXXX",
		                                    "XXXXXXXX",
		                                    "XXXXXXXX",
		                                    "XXXXXXXX",
		                                    "XXXXXXXX",
		                                    "XXXXXXXX",
		                                    "XXXXXXXX",
		                                    "XXXXXXXX"})},
	       {"Frame Type", "Rounded Rectangle"},
	       {"Text", "Framed Text"}}
	      ) 	                                 

endMacro